/**
* \file: logger.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_UTIL_LOGGER_H
#define ALD_UTIL_LOGGER_H

#include <stdbool.h>
#include "ald_types.h"

void logger_init(const char *proc_name, logger_loglevel_t min_level, bool console_enabled);

void logger_init_console_only(logger_loglevel_t min_level);

void logger_deinit(void);

void logger_set_log_level(logger_loglevel_t log_level);

void logger_set_console_enabled(bool enabled);

void logger_open_console_log(void);

void logger_close_console_log(void);

error_code_t logger_parse_loglevel(const char *level_str, logger_loglevel_t *result_ptr);

void logger_open_syslog(void);

void logger_close_syslog(void);

void logger_log_error(const char *message, ...);

void logger_log_info(const char *message, ...);

void logger_log_debug(const char *message, ...);

void logger_log_status(const char *message, ...);

void logger_log_errmem(const char *message, ...);

#endif
